/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.installertools.util.ManifestJson;
import net.minecraftforge.installertools.util.VersionJson;

public class DownloadMojmaps
extends Task {
    private static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec versionO = parser.accepts("version").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec sideO = parser.accepts("side").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        try {
            OptionSet options = parser.parse(args);
            String mcversion = (String)options.valueOf((OptionSpec)versionO);
            String side = (String)options.valueOf((OptionSpec)sideO);
            File output = (File)options.valueOf((OptionSpec)outputO);
            this.log("MC Version: " + mcversion);
            this.log("Side:       " + side);
            this.log("Output:     " + output);
            if (output.exists() && !output.delete()) {
                this.error("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                this.error("Could not make output folders: " + output.getParentFile());
            }
            try (InputStream manIn = new URL(MANIFEST_URL).openStream();){
                URL url = ((ManifestJson)GSON.fromJson((Reader)new InputStreamReader(manIn), ManifestJson.class)).getUrl(mcversion);
                if (url == null) {
                    this.error("Missing version from manifest: " + mcversion);
                }
                try (InputStream verIn = url.openStream();){
                    VersionJson.Download download;
                    VersionJson json = VersionJson.load(verIn);
                    if (json == null) {
                        this.error("Missing Minecraft version JSON from URL " + url);
                    }
                    if ((download = json.downloads.get(side + "_mappings")) == null || download.url == null) {
                        this.error("Missing download info for " + side + " mappings");
                    }
                    Files.copy(download.url.openStream(), output.toPath(), new CopyOption[0]);
                    this.log("Downloaded Mojang mappings for " + mcversion);
                }
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }
}

